par(mfrow = c(1,1))
library(imager)
library(matrixStats)
library(scales)
library(gtools)
library(inflection)
options(scipen = 999)

#inputDirectory = '/Users/gfivash/Dropbox/Greg/Work/PhD/Thesis Chapters/Chapter 3 - Sediment hummocks/Data/Oxygen/Oxygen experiment/Data/Experiments/Exp 1 Flat 10h2h/E1-flatone-2h vs 10h-0-100-jpg/'
inputDirectory = '/Users/gfivash/Dropbox/Greg/Work/PhD/Thesis Chapters/Chapter 3 - Sediment hummocks/Data/Oxygen/Oxygen experiment/Data/Experiments/Exp 5 +1cm 10h2h/E5-hummock1cm-2h vs 10h-jpg/'
#inputDirectory = '/Users/gfivash/Dropbox/Greg/Work/PhD/Thesis Chapters/Chapter 3 - Sediment hummocks/Data/Oxygen/Oxygen experiment/Data/Experiments/Exp 6 -1cm 10h2h/E6-hollow1cm-2h vs 10h-jpg/'
setwd(inputDirectory)

# make a list for sorted images in the file folder
filelist = mixedsort(dir())

# time settings
starttime = as.POSIXct('2018-06-20 17:36:00')
interval = 120  # 2min=120s between adjacent two images

outputDirectory = '/Users/gfivash/Desktop/Oxygen GIF/'
setwd(outputDirectory)
png('%04d.png')

# oxygenDeclineRate = vector(mode = 'numeric', length = length(filelist))
# inflection = vector(mode = 'numeric', length = length(filelist))
for(i in 1:length(filelist)){
  #i = round(runif(n = 1, min = 1, max = length(filelist)))
  setwd(inputDirectory)
  filename = filelist[i]
  
  # load images, grayscale, crop, convert class from image to matrix
  p = load.image(filename)
  p.g = grayscale(p)
  p.g.c = as.cimg(p.g[205:660,120:710, 1, 1])
  m = as.matrix(p.g.c)
  m = m*100
  # par(mfrow = c(1, 2))
  # plot(p.g)
  # plot(p.g.c)
  
  # synchronize depth layers in cm and in pixel
  depth = seq(0,6.24, length.out = dim(m)[2]) # depth in "cm"
  
  # calculate the mean values and SE in columns
  se = colSds(m)/sqrt(dim(m)[1])
  oxygen.mean = colMeans(m)
  
  #plot the oxygen concentration vs depth
  setwd(outputDirectory)
  par(mfrow = c(1,1))
  plot(c(1), xlim = c(0.0005,100),ylim = c(7,0), log ='',
       type = 'n',
       xlab = 'Oxygen saturation (%)', ylab = 'Depth in sampled frame (cm)')
  arrows(y0 = depth, y1 = depth, x0 = oxygen.mean + se, x1 = oxygen.mean - se,
         code = 3, angle = 90, length = 0.01)
  points(depth ~ colMeans(m), ylim = c(0,1), pch = 21,
         bg = alpha(grey(colMeans(m)/100),0.8), cex = 0.5)
  lines(x = c(-0.5,1.5), y = c(sedimentSurfaceDepth.cm, sedimentSurfaceDepth.cm), lty = 2)
  title(filename)
  
  inflectionPoint = bese(depth, oxygen.mean, index = 1)$iplast
  filter = which.min(abs(depth - inflectionPoint))
  points(depth[filter] ~ oxygen.mean[filter], cex = 2, pch = 21, bg = alpha('green',0.5))

  filter = depth > inflectionPoint
  y = oxygen.mean[filter]
  x = depth[filter] - min(depth[filter])
  y = y[x < 0.4]
  x = x[x <  0.4]

  # plot(y ~ x, log ='')
  m = lm(log(y) ~ x)
  summary(m)
  a = summary(m)$coefficients[1]
  b = summary(m)$coefficients[2]
  xv = seq(0,3, length.out = 1000)
  yv = exp(a + b*xv)
  # lines(yv ~ xv)
  xv2 = xv + min(depth[filter])
  lines(xv2[yv > 0.001] ~ yv[yv > 0.001], col = alpha('green',0.5), lwd = 4)
  
  print(paste(i,'/',length(filelist), sep = ' '))
  
  oxygenDeclineRate[i] = b
  inflection[i] = inflectionPoint
  
}
dev.off()
system("convert -delay 10 *.png hummock.gif")
file.remove(list.files(pattern=".png"))

oxygenDeclineRate[oxygenDeclineRate > 0] = NA
write.csv(oxygenDeclineRate, 'hummockOxygenDeclineRate.csv', row.names = F)
write.csv(inflection, 'hummockInflectionPoint.csv', row.names = F)
# -------------

hummock = -read.csv('hummockOxygenDeclineRate.csv')$x
flat = -read.csv('flatOxygenDeclineRate.csv')$x
hollow = -read.csv('hollowOxygenDeclineRate.csv')$x

windowSize = 5
n_windows = floor(length(flat)/windowSize)
hummockRate = c()
hollowRate = c()
flatRate = c()
time = c()

for(window in 1:n_windows){
  start = 1 + windowSize*(window - 1)
  end = windowSize*window
  
  hummockRate[window] = mean(hummock[start:end], na.rm = T)
  flatRate[window] = mean(flat[start:end], na.rm = T)
  hollowRate[window] = mean(hollow[start:end], na.rm = T)
  time[window] = mean(c((start - 1)*2,(end - 1)*2))/60
}
colSeq = c('yellow','green','blue')
par(mfrow = c(2,1))
plot(hummockRate ~ time, type= 'l', ylim = c(0, 7), col = alpha('blue',0.5), lwd = 2,
     ylab = 'Oxygen decline rate', xlab = 'Time (Hours)')
lines(flatRate ~ time, col = alpha('green',0.5), lwd = 2)
lines(hollowRate ~ time, col = alpha('yellow',0.5), lwd = 2)

#boxplot(hollow, flat, hummock, col = alpha(colSeq, 0.5), notch = T)
boxplot(hollowRate, flatRate, hummockRate, col = alpha(colSeq, 0.5), 
        notch = T, ylim = c(0,7), 
        ylab = 'Oxygen decline rate', xlab = 'Sediment shape',
        names = c('Hollow','Flat','Hummock'))
sedimentShape = factor(c(rep('hollow',times = length(hollowRate)),
                  rep('flat',times = length(flatRate)),
                  rep('hummock',times = length(hummockRate))), 
                  levels = c('hollow','flat','hummock'))
oxygenDecayRate = c(hollowRate, flatRate, hummockRate)

m = lm(oxygenDecayRate ~ sedimentShape + 0)
summary(m)
